func fixtf (abstract netlist nl) {
	abstract instance ip
	abstract view instof
	abstract instance pp outp
	abstract instance inl
	abstract connection cn
	abstract net np
	list vccpins gndpins
	untyped ptr

	vccpins = gndpins = '()
	foreach ip (instances @nl) {
		instof = @ip._instof
		if @instof._external {
			switch @instof._cell._name {
			    TRUE  (ptr = &vccpins)
			    FALSE (ptr = &gndpins)
			    ()    (ptr = ())
			}
			if @ptr {
				outp = (findconn @ip out)
				foreach cn (inputs @outp._net) {
					prepend @ptr @cn
				}
				deleteabs @ip
			}
		} else {
			fixtf @instof._netlist
			updateinstance @ip
			cn = (catch () findconn @ip VCC)
			if @cn (prepend vccpins @cn)
			cn = (catch () findconn @ip GND)
			if @cn (prepend gndpins @cn)
		}
	}
	if @vccpins {
                pp = ( catch() findport @nl VCC)
		if (! @pp) ( pp = (addport @nl I VCC))
                np = ( catch() findnet @nl VCC)
                if ( ! @np ) ( np = (addnet @nl VCC))
		pp._portnet = @np 
		foreach cn @vccpins (cn._net = @np)
	}
	if @gndpins {
                pp = ( catch() findport @nl GROUND )
	        if (! @pp) (pp = (addport @nl I GROUND))
                np = ( catch() findnet @nl GND )
                if ( @np) ( np._name = GROUND)
                if ( ! @np ) ( np = (catch() findnet @nl GROUND))
                if ( ! @np ) ( np = (addnet @nl GROUND))
                pp._portnet = @np
		foreach cn @gndpins (cn._net = @np)
	}
}
func wr_altera_edif () {
        untyped x  
	global int _altera_index

        x = (rd_gn (get_tmp_filename GN))
        fixtf @x
	_altera_index = 0
	altera_rename_objs  ALTERARENAMEFIELD @x
        #movefunc edifify old_edifify
        #movefunc new_edifify edifify
        wr_edif (get_tmp_filename EDIF)  @x '{
		cell (altera_get_objname @u)
	}
	quit 0
Error:
	println (errorinfo)
        quit 1
}


func wr_altera_netlist (args fname partsize ) {
	string s ss design dest_path source_path
	int rc i j
        list tmp_list
        untyped type
 
        dest_path = ""
        if (!@partsize) (partsize = None)
        #println file @fname partition size @partsize
	if (!@fname) (fname = altera.edf)
	ss = @fname
	if (instr @ss "/") {
		i = (revscan @ss "/")
		j = (strlen @ss)
		ss = (substr @ss (@i + 1) (@j - 1))
	} 
	if (instr @ss ".") {
		i = (revscan @ss ".")
		ss   = (substr @ss 0 @i)
	}
	design = @ss
	if (!@design) (design = design)
	#if (! @Netlist._mapped) (opt_area map)
	if (! @Netlist._mapped) {
                println "Warning: source cells in netlist (mapping now)"
                opt_area low
	}
	# insert_altera_softcells @Netlist @partsize
	if (@Netlist._view._parent) (return)
        Techdef.wr_edif = 1
        hier_walk @Netlist {
        		       foreach type '(net instance port) {
              			lo_shorten_names 15 @type
        			}
                           }
	wr_gn (get_tmp_filename GN)
        Techdef.wr_edif = 0
	save fixtf (get_tmp_filename M)
	save wr_altera_edif (get_tmp_filename M) append
	save altera_rename_objs (get_tmp_filename M) append
	save altera_get_objname (get_tmp_filename M) append
        save get_tmp_filename (get_tmp_filename M) append
        if @Netlist._view.syn_eddm_path {
              dest_path =  (cat @Netlist._view.syn_eddm_path  "/max2")
        } else {
           dest_path = "max2" 
        }
        tmp_list = '()
        tmp_list = (dirs)
        foreach source_path @tmp_list {}
        if(!(isdirectory @dest_path)){
            sys_mkdir @dest_path 
        }
        chdir @dest_path
        s = (cat "Np -load " (get_tmp_filename M) " -t " @Techdef.name " -exec wr_altera_edif")
	rc = (sys @s)
	if (@rc) {
                printf "ERROR writing EDIF file %s/%s\n" @dest_path @fname
		goto Error
	}
        printf "Writing EDIF file %s/%s\n" @dest_path @fname
	#fprintf s "sed \"s/\&_XN_SETLIST/%s/g\" %s > %s" @design 
        s = (cat "sed \"s/altera_//g\" " (get_tmp_filename EDIF) " > " (get_tmp_filename TMP))
        sys @s 
        s = (cat "rm " (get_tmp_filename EDIF))
        sys @s 
        s = (cat "mv " (get_tmp_filename TMP) " " (get_tmp_filename EDIF))
        sys @s
	fprintf s "sed \"s/ALTERARENAMEFIELD/%s/g\" %s > %s" @design \
		  (get_tmp_filename EDIF) @fname
	sys @s
        chdir @source_path
Error:
	println (errorinfo)
	unlink (get_tmp_filename GN) 
	unlink (get_tmp_filename EDIF)
	unlink (get_tmp_filename M)
}

func altera_rename_objs (string name; abstract netlist nl) {
	untyped x y 

	y = @nl._view._cell
	if (!@_altera_index) {
		y.altera_rename = @name
		_altera_index ++
	} else {
		y.altera_rename = (cat @name (_altera_index ++))
	}
	y._rename = ""
	foreach y (instances @nl) {
		if (@y._instof._external) (continue)
		altera_rename_objs @name @y._instof._netlist
	}
}

func altera_get_objname (args u) {
	
	if (@u.altera_rename) (return @u.altera_rename)
	return @u._name
}

func get_tmp_filename (string ftype) {

string fname prefix
   
    prefix = (getenv MGC_TMPDIR) 
    if (isnull @prefix) { prefix =  (cat (getenv MGC_HOME) "/tmp")}
    if (isnull @prefix) { prefix  = "/tmp" }

 switch (upper @ftype) {
         case M     { fname = (cat @prefix "/altera_mkedif.m") }
         case EDIF  { fname = (cat @prefix "/altera_edif.edf") }
         case GN    { fname = (cat @prefix "/altera_gn.gn")}
         case TMP   {fname = (cat @prefix "/altera_edif.tmp") }
  }

return @fname
}

with Base func lo_collectrecipesr(float time; string optname; const list optargs; string opttype; abstract netlist nl) {
        abstract instance ip
        abstract view v

        foreach ip (modules @nl) {
                v = @ip._instof
                if ( (@optname != wr_altera_netlist) && ( @ip._donttouch)) (continue)
                if(@v.synrecipemaps && (isinlist @opttype @v.synrecipemaps)) (continue)
                if( (@optname != wr_altera_netlist) && (isnotnull @v."syn:dont_touch")) (continue)
                prepend Recipes (bld @time (assn '{
                        time    @time
                        depth   @v.syndepth
                        path    (lo_getviewname @v)
                        optname @optname
                        optargs @optargs
                }))
                lo_collectrecipesr @time @optname @optargs @opttype @v._netlist
        }
}
